unit TBOutLn;
{ TBOutLn.pas - Tree Builder Outline enables you to design a unique tree }
{ eliminating duplicates at any child level. }
{ Copyright (c) 1996. All Rights Reserved.  }
{ by Software Conceptions, Inc 800-471-5890 }
{ Written by Paul Kimmel. }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, Outline;

type

  EOutlineException = class(Exception);

  TTBOutline = class(TOutline)
  private
    { Private declarations }

  protected
    { Protected declarations }
    Function HasZeroItem( Const Text : String ) : Boolean;
    Function HasItem( Index : Longint; const Text : String ) : Boolean;
    Function AreEqual( Const ListItem, Value : String ) : Boolean;

  public
    { Public declarations }
    Function AddChildNoDups(Index: LongInt; const Text: string): LongInt;
    Function AddNoDups(Index: LongInt; const Text: string): LongInt;
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Custom Controls', [TTBOutline]);
end;

Function TTBOutline.AddChildNoDups(Index: LongInt; const Text: string): LongInt;
begin
     if( HasItem( Index, Text ) = False ) then
         AddChild( Index, Text )
     else
         Raise EOutLineException.Create('Duplicate Item Found.');
end;

Function TTBOutline.AddNoDups(Index: LongInt; const Text: string): LongInt;
begin
     AddChildNoDups( Index, Text );
end;


Function TTBOutline.AreEqual(Const ListItem, Value : String ) : Boolean;
begin
    Result := ( CompareText( ListItem, Value ) = 0);
end;


{ Used for zero level items. }
Function TTBOutline.HasZeroItem( Const Text : String ) : Boolean;
var
   I: Longint;
begin
     Result := False;
     For I := 1 to ItemCount do
         if( AreEqual( Items[I].Text, Text ) And (Items[I].Level = 1 )) then
         begin
              Result := True;
              Exit;
         end;
end;


Function TTBOutline.HasItem( Index : Longint; const Text : String ) : Boolean;
Const
     NO_MORE_ITEMS = -1;
var
   I : Longint;
begin
     Result := False;

     { Special check if index is 0. }
     if( Index <= 0 ) then
     begin
          Result := HasZeroItem( Text );
          Exit;
     end;

     if( Self[Index].HasItems = False ) then exit;

     I := Self[Index].GetFirstChild;

     while( I <> NO_MORE_ITEMS ) do
     begin
          if( AreEqual( Items[I].Text, Text ) ) then
          begin
               Result := True;
               Exit;
          end;
          { Use same parent index, changing the child index. }
          I := Self[Index].GetNextChild( I );
     end;
end;
end.
